//
//  BIAssistantTaxesSetup.h
//  Assistant
//
//  Created by Alykhan Jetha on 10/04/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <MCAssistant/MCAssistantAbstractPane.h>

@class MCTVToolbarView;
@class MCTableView;

@interface BIAssistantTaxesSetup : MCAssistantAbstractPane {

    IBOutlet NSArrayController* taxesController;
    IBOutlet NSArrayController* consolidatedTaxesController;
    IBOutlet NSArrayController* consApplicableTaxesController;
 
    IBOutlet MCTVToolbarView* consTaxTVToolbarView;
    IBOutlet MCTVToolbarView* taxTVToolbarView;
    IBOutlet MCTVToolbarView* consApplicableTaxTVToolbarView;
    
    IBOutlet MCTableView* consApplicableTaxTableView;
    IBOutlet MCTableView* consTaxTableView;
    IBOutlet MCTableView* taxTableView;
    
    IBOutlet NSComboBox* taxNameComboBox;
}

- (void)setPrimaryTaxName:(NSString *)name;
- (NSString *)primaryTaxName;

- (id)primaryTaxRate;
- (void)setPrimaryTaxRate:(id)rate;

- (BOOL)usePrimaryTax;
- (void)setUsePrimaryTax:(BOOL)use;


- (void)setSecondaryTaxName:(NSString *)name;
- (NSString *)secondaryTaxName;

- (id)secondaryTaxRate;
- (void)setSecondaryTaxRate:(id)rate;

- (BOOL)useSecondaryTax;
- (void)setUseSecondaryTax:(BOOL)use;

- (BOOL)compoundSecondaryTax;
- (void)setCompoundSecondaryTax:(BOOL)use;

- (void)setupToolbars;
- (void)refreshToolbars;
- (void)setupTaxTVToolbarView;
- (void)setupConsTaxTVToolbarView;
- (void)setupConsApplicableTaxTVToolbarView;

- (IBAction)createTax:(id)sender;
- (BOOL)canCreateTax;
- (IBAction)deleteTax:(id)sender;
- (BOOL)canDeleteTax;
- (IBAction)editTax:(id)sender;
- (BOOL)canEditTax;
- (void)taxSheetDidEnd:(NSWindow*)sheet
            returnCode:(int)returnCode
           contextInfo:(void*)contextInfo;


- (IBAction)createConsolidatedTax:(id)sender;
- (BOOL)canCreateConsolidatedTax;
- (IBAction)deleteConsolidatedTax:(id)sender;
- (BOOL)canDeleteConsolidatedTax;

- (IBAction)addTaxToConsTax:(id)sender;
- (BOOL)canAddTaxToConsTax;
- (IBAction)deleteTaxFromConsTax:(id)sender;
- (BOOL)canDeleteTaxFromConsTax;

- (void)setupConsApplicableTaxesController;

- (void)addTaxToConsTaxSheetDidEnd:(NSWindow*)sheet
                        returnCode:(int)returnCode
                       contextInfo:(void*)contextInfo;

- (IBAction)saveTaxSetup:(id)sender;
- (IBAction)restoreTaxSetup:(id)sender;

- (IBAction)openLegacy:(id)sender;

- (void)updateConsApplicableTaxTVToolbarView;

- (void)setupTaxesController;
- (void)setupConsolidatedTaxesController;

- (void)refreshControllers;
- (void)refreshConsolidatedTaxesController;
- (void)refreshTaxesController;
- (void)refreshConsApplicableTaxesController;

- (IBAction)restoreTaxSetup:(id)sender;
- (void)openRestoreTaxPanelDidEnd:(NSWindow*)sheet
                       returnCode:(int)returnCode
                      contextInfo:(void*)contextInfo;

- (IBAction)openCustomTaxSetup:(id)sender;
- (void)openCustomTaxPanelDidEnd:(NSOpenPanel*)openPanel
                      returnCode:(int)returnCode
                     contextInfo:(void*)x;

- (BOOL)canEditTable;
- (void)setCanEditTable:(BOOL)aFlag;

- (IBAction)help:(id)sender;

@end
